/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.font.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gg.essential.elementa.font.data.FontInfo;
import gg.essential.universal.UGraphics;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgg/essential/elementa/font/data/Font;", "", "fontInfo", "Lgg/essential/elementa/font/data/FontInfo;", "atlas", "Ljava/io/InputStream;", "(Lgg/essential/elementa/font/data/FontInfo;Ljava/io/InputStream;)V", "getFontInfo", "()Lgg/essential/elementa/font/data/FontInfo;", "texture", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "getTexture", "Companion", "Elementa"})
public final class Font {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FontInfo fontInfo;
    @NotNull
    private final InputStream atlas;
    private ReleasedDynamicTexture texture;

    public Font(@NotNull FontInfo fontInfo, @NotNull InputStream atlas) {
        Intrinsics.checkNotNullParameter(fontInfo, "fontInfo");
        Intrinsics.checkNotNullParameter(atlas, "atlas");
        this.fontInfo = fontInfo;
        this.atlas = atlas;
    }

    @NotNull
    public final FontInfo getFontInfo() {
        return this.fontInfo;
    }

    @NotNull
    public final ReleasedDynamicTexture getTexture() {
        ReleasedDynamicTexture releasedDynamicTexture;
        if (this.texture == null) {
            ReleasedDynamicTexture releasedDynamicTexture2 = UGraphics.getTexture(this.atlas);
            Intrinsics.checkNotNullExpressionValue((Object)releasedDynamicTexture2, "getTexture(atlas)");
            this.texture = releasedDynamicTexture2;
        }
        if ((releasedDynamicTexture = this.texture) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("texture");
            releasedDynamicTexture = null;
        }
        return releasedDynamicTexture;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/elementa/font/data/Font$Companion;", "", "()V", "fromResource", "Lgg/essential/elementa/font/data/Font;", "path", "", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font fromResource(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            InputStream json = this.getClass().getResourceAsStream(path + ".json");
            JsonParser jsonParser = new JsonParser();
            Intrinsics.checkNotNullExpressionValue(json, "json");
            InputStream inputStream = json;
            Charset charset = Charsets.UTF_8;
            JsonObject jsonObject = jsonParser.parse(new InputStreamReader(inputStream, charset)).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue(jsonObject, "JsonParser().parse(json.reader()).asJsonObject");
            FontInfo fontInfo = FontInfo.Companion.fromJson(jsonObject);
            InputStream inputStream2 = this.getClass().getResourceAsStream(path + ".png");
            Intrinsics.checkNotNullExpressionValue(inputStream2, "this::class.java.getResourceAsStream(\"$path.png\")");
            return new Font(fontInfo, inputStream2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

